﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.IO;

using Ivi.Visa.Interop;

namespace PowerAmpDemoNS
{
    public class Dio
    {
        // Scout DIO
        public bool enableRffe = false;
        ResourceManager oRm;
        FormattedIO488 scoutIo;
        public string rffeResource = "COM5";
        public int[] rffeAddress;
        public int[] rffeRegister;
        public int[] rffeData;
        public bool[] rffeReadback;
        public int[] rffeReadData;

        public void initRffeDio()
        {
            if (!enableRffe)
                return;

            if (oRm == null)
                oRm = new ResourceManager();
            scoutIo = new FormattedIO488();

            //Open session for instrument.
            try
            {
                scoutIo.IO = (IMessage)oRm.Open(rffeResource, AccessMode.NO_LOCK, 2000, "");

                // Set VIO to 1.8 V
                string cmd = string.Format("VIO {0}\n", 2); // 0 = External, 1 = 1.2V, 2 = 1.8V
                scoutIo.WriteString(cmd);
                string result = scoutIo.ReadString();
                // Set clock to 26 MHz
                cmd = string.Format("CLK {0}\n", 0); // 0 = 26 MHz, 1 = 13 MHz, 2 = 1 MHz
                scoutIo.WriteString(cmd);
                result = scoutIo.ReadString();

            }
            catch (Exception ex)
            {
                throw (ex);
            }
        }

        public void writeRffe(int addr, int register, int data)
        {
            if (!enableRffe)
                return;

            string cmd = string.Format("RW {0} {1} {2}\n", addr, register, data);
            try
            {
                scoutIo.WriteString(cmd);
                string result = scoutIo.ReadString();
            }
            catch (Exception ex)
            {
                throw (ex);
            }
        }
        public int readRffe(int addr, int register)
        {
            if (!enableRffe)
                return -1;

            string cmd = string.Format("RR {0} {1}\n", addr, register);
            int value = -1;
            string result = "";
            try
            {
                scoutIo.WriteString(cmd);
                result = scoutIo.ReadString();
                scoutIo.WriteString("read");
                //string[] resultList = (string[])scoutIo.ReadList(IEEEASCIIType.ASCIIType_BSTR, "\n");
                //Delay(50);
                //byte[] readBuffer = new byte[500];
                //readBuffer = scoutIo.IO.Read(500);
                //result = Encoding.UTF8.GetString(readBuffer, 0, readBuffer.Length);

                //result = scoutIo.IO.ReadString(500);
                // Readback from the Scout:
                // Read
                // Read Buffer
                // byte[0] 0xnn, parity = n
                // byte[1] ---
                // ...
                // byte[15] ---
                int readCount = 0;
                while (!result.Contains("byte[15]") && readCount < 20)
                {
                    result = scoutIo.ReadString();
                    readCount++;
                    if (result.Contains("byte[0]"))
                    {
                        char[] seps = new char[] { ';', ',', ':', 'x' };
                        string[] columns = result.Split(seps);
                        value = Convert.ToInt32(columns[2], 16);
                    }
                }
                //result.Remove(0, result.IndexOf("byte[0]", 0));
                // Parse the line byte[0] 0xnn, parity... to get the "nn"
                //                       | |  |
                //    scoutIo.FlushRead();
                //    scoutIo.IO.
            }
            catch (Exception ex)
            {
                throw (ex);
            }
            return value;
        }

        public void sendRffeCommands()
        {
            if (!enableRffe)
                return;

            // Set the readback data to all zeros
            Array.Clear(rffeReadData, 0, rffeReadData.Length);

            for (int i = 0; i < rffeAddress.Length; i++)
            {
                writeRffe(rffeAddress[i], rffeRegister[i], rffeData[i]);
                if (rffeReadback[i])
                    rffeReadData[i] = readRffe(rffeAddress[i], rffeRegister[i]);
            }
        }

        // readRffeCommandData
        // Reads a RFFE Command data file with the following format:
        /*
                Commands,2,
                ,,
                Command Data,,
                Address, Register, Data, Read Back
                0,0,0,TRUE
                1,1,255,FALSE

        */
        public void readRffeCommandData(string filePath, string fileName)
        {
            int numCommands = 0;

            // Clean up any old DC Setup data
            if (rffeAddress != null) rffeAddress = null;
            if (rffeRegister != null) rffeRegister = null;
            if (rffeData != null) rffeData = null;
            if (rffeReadback != null) rffeReadback = null;
            if (rffeReadData != null) rffeReadData = null;

            // Open the file
            var rs = new FileStream(filePath + fileName, FileMode.Open);
            TextReader rd = new StreamReader(rs);

            string fileString;
            // Read the data size values
            while (numCommands == 0)
            {
                fileString = rd.ReadLine();
                fileString = fileString.ToUpper();
                string[] columns = fileString.Split(',');
                if (columns[0].Contains("COMMANDS")) numCommands = Convert.ToInt32(columns[1]);
            }

            // Size the DC Setup arrays
            rffeAddress = new int[numCommands];
            rffeRegister = new int[numCommands];
            rffeData = new int[numCommands];
            rffeReadback = new bool[numCommands];
            rffeReadData = new int[numCommands];
            // Set the readback data to all zeros
            Array.Clear(rffeReadData, 0, rffeReadData.Length);

            bool commandDataRead = false;
            while (!commandDataRead)
            {
                fileString = rd.ReadLine();
                fileString = fileString.ToUpper();
                if (fileString.Contains("COMMAND DATA"))
                {
                    int linesRead = 0;
                    while (linesRead < numCommands)
                    {
                        fileString = rd.ReadLine();
                        fileString = fileString.ToUpper();
                        if (fileString.Contains("ADDRESS") || fileString.Contains("//"))
                        {
                            // Skip Header or comment line
                        }
                        else
                        {
                            // Read the command data
                            string[] columns = fileString.Split(',');
                            rffeAddress[linesRead] = Convert.ToInt32(columns[0]);
                            rffeRegister[linesRead] = Convert.ToInt32(columns[1]);
                            rffeData[linesRead] = Convert.ToInt32(columns[2]);
                            rffeReadback[linesRead] = Convert.ToBoolean(columns[3]);
                            linesRead++;
                        }
                    }
                    commandDataRead = true;
                }
            }
            rd.Close();
            rs.Close();
        }

    }
}
